--
-- testUpdateSubset.sql
--
CREATE OR REPLACE PROCEDURE testUpdateSubset
  (xmlDoc IN CLOB)
IS
  v_updCtx DBMS_XMLSave.ctxType;
  v_rows   NUMBER;
BEGIN
   v_updCtx := DBMS_XMLSave.newContext('hr.employees');
   DBMS_XMLSave.setKeyColumn(v_updCtx,'EMPLOYEE_ID'); -- set key column

   -- set list of columns to update
   DBMS_XMLSave.setUpdateColumn(v_updCtx,'SALARY');
   DBMS_XMLSave.setUpdateColumn(v_updCtx,'EMAIL');

   v_rows := DBMS_XMLSave.updateXML(v_updCtx,xmlDoc); -- update the XML document
   DBMS_XMLSave.closeContext(v_updCtx);   -- close the handle
END;
/
